/* Description : Test control via dtmf tone
               : Press key 1 for on LED,Press key 2 for off LED
   Hardware    : ET-GSM SIM900B + ET-MINI MT8870 + Arduino */

#define StD_PIN  2   // Connect StD to digital pin 2
#define Q1_PIN   3   // Connect Data Q1 to digital pin 3
#define Q2_PIN   4   // Connect Data Q2 to digital pin 4
#define Q3_PIN   5   // Connect Data Q3 to digital pin 5
#define Q4_PIN   6   // Connect Data Q4 to digital pin 6
#define LED_PIN  13  // Connect LED to digital pin 13

byte DTMF_value;

void setup()
{
 // Configures Serial Port @ 9600,8,N,1
 Serial.begin(9600);

 // Configure PIN mode
 pinMode(StD_PIN, INPUT);
 pinMode(Q1_PIN, INPUT);
 pinMode(Q2_PIN, INPUT);
 pinMode(Q3_PIN, INPUT);
 pinMode(Q4_PIN, INPUT);
 pinMode(LED_PIN, OUTPUT);
}

void loop()
{
      DTMF_value = GetDTMF(); // Reads DTMF code
  
      switch (DTMF_value) 
      {
        case 1:
           Serial.println("You press key : 1");
           digitalWrite(LED_PIN, HIGH);                // LED on
        break;
        case 2:
           Serial.println("You press key : 2");
           digitalWrite(LED_PIN, LOW);                 // LED off
        break;
        case 3:
           Serial.println("You press key : 3");
        break;
        case 4:
           Serial.println("You press key : 4");
        break;
        case 5:
           Serial.println("You press key : 5");
        break;
        case 6:
           Serial.println("You press key : 6");
        break;
        case 7:
           Serial.println("You press key : 7");
        break;
        case 8:
           Serial.println("You press key : 8");
        break;
        case 9:
           Serial.println("You press key : 9");
        break;
        case 10:
           Serial.println("You press key : 0");
        break;
        case 11:
           Serial.println("You press key : *");
        break;
        case 12:
           Serial.println("You press key : #");
        break; 
      }   
}

byte GetDTMF()
{
  static byte last_state = LOW; // initialization
  byte ret_val = 0xff;          // default - not valid

  if (digitalRead(StD_PIN)==HIGH
      && last_state == LOW) {
    // valid DTMF signal => decode it
    last_state = HIGH; // remember last state

    ret_val = 0;
    if (digitalRead(Q1_PIN)) ret_val |= 0x01;
    if (digitalRead(Q2_PIN)) ret_val |= 0x02;
    if (digitalRead(Q3_PIN)) ret_val |= 0x04;
    if (digitalRead(Q4_PIN)) ret_val |= 0x08;
  }
  else if (digitalRead(StD_PIN) == LOW) {
    // pulse is not valid => enable to check DTMF signal again
    last_state = LOW;
  }
  return (ret_val);
}

